#!/bin/sh
#
# Shell script to install Java-based GUI RAID Manager.
 
SRCDIR=`pwd`
OSDIR=${SRCDIR}
COMDIR=${SRCDIR}

if [ ! -r /usr/.path.ori ]; then
   echo "`echo $PATH`" > /usr/.path.ori
fi

# Set path for JRE
export PATH; PATH=/usr/Solaris_JRE_1.2.2_05/bin:$PATH

more << "EOF"

        *************************************************************
             Java-based GUI RAID Manager Installation Procedure
        *************************************************************

SECTION I : Pre-Installation (Patches Installation)

*NOTE: Before you can install JRE v1.2 (Java Runtime Enviroment) successfully, you should have installed patches for Solaris 7 .

!!! PLEASE DOWNLOAD THE PATCHES REQUIRED FROM SUN'S WEB SITE, AND INSTALL IT !!!

EOF

echo "If you have downloaded patches, and put them on proper directory, install program will install patches for you."
echo
echo "Would you like to auto-install the patches now ?"
echo
echo "*NOTE: 1.You need to download patches tar file in advance."
echo "       2.Then, put the tar file on \"/usr/patches/\" ."
echo
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          mkdir -p /usr/patches 
          echo 
          echo "You are going to install patches now."
          echo "Please check to see if the patches tar file is on \"/usr/patches/\" ."
          echo
          echo "Would you like to continue ?"
          agreed=
          while [ x$agreed = x ]; do
             echo "Please type yes or no."
             read reply
             case $reply in
                y* | Y*)
                   echo
                   echo "Start to install patches ..."
                   echo
                   cd /usr/patches
                   mkdir -p tarfile
                   for file in *.tar  
                   do
                      tar -xvf $file
                   done   
                   if [ ! -d 5.7 ]; then
                      echo
                      echo "patches tar file doesn't exist !"
                      echo
                      echo "Patches installation failed !"
                      exit 1
                   fi   
                   cd 5.7
                   for file in *.Z
                   do
                      uncompress $file
                   done
                   for file in *.tar
                   do 
                      tar -xvf $file
                      mv $file ../tarfile
                   done
                   for file in *
                   do
                      patchadd $file
                   done  
                   rm -fr /usr/patches/tarfile > /dev/null 2>&1
                   rm -fr /usr/patches/5.7 > /dev/null 2>&1
                   echo         
                   echo "Patches installation finished."                   
                   echo
                   agreed=1;;
                n* | N*)
                   exit 0;;
             esac
          done                          
          agreed=1;;
       n* | N*)
          echo
          echo "Please make sure you have installed patches for Solaris 7 ."
          echo "Then, you may step into JRE v1.2.2 installation procedure."
          echo
          echo "Would you like to continue ?"
          agreed=
          while [ x$agreed = x ]; do
             echo "Please type yes or no."
             read reply
             case $reply in
                y* | Y*)
                   agreed=1;;
                n* | N*)
                   exit 0;;
             esac
          done                          
          agreed=1;;
    esac
done

more << "EOF"
------------------------------------------------------------------------------------

SECTION II : JRE v1.2 Installation

*NOTE: Before you can run Java-based program successfully, you should have
       installed JRE(Java Runtime Enviroment). 
         
EOF
  
echo "Would you like to install JRE v1.2 now ?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          cd /usr
          ${OSDIR}/jre2.bin;
          agreed=1;;
       n* | N*)
          echo "Install JRE v1.2 Canceled !"
          agreed=1;;
    esac
done

# Add path for JRE 
PATH=/usr/Solaris_JRE_1.2.2_05/bin:`cat /usr/.path.ori`; export PATH

more << "EOF"

-----------------------------------------------------------------------------
SECTION III : Java Plug-in v1.2 Installation

*NOTE: If you would like to run Java-based GUI RAID Manager through web
       browser(e.g. Netscape Navigator), you should have install Java Plug-
       in. 

EOF
 
echo "Would you like to install Java Plug-in v1.2 now ?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          cd /usr
          tar -xvf ${OSDIR}/j2pi.tar
          pkgadd -d . SUNWj2pi
          rm -f SUNWj2pi > /dev/null 2>&1
          agreed=1;;
       n* | N*)
          echo "Install Java Plug-in v1.2 Canceled !" 
          agreed=1;;
    esac
done

# Install .java.policy & .keystore
(cp -f ${COMDIR}/keystore.jav ${HOME}/.keystore) > /dev/null 2>&1
(cp -f ${COMDIR}/policy.jav ${HOME}/.java.policy) > /dev/null 2>&1

more << "EOF"

        *************************************************************
             Java-based GUI RAID Manager Installation Procedure
        *************************************************************

SECTION I: Java-based GUI RAID Manager Installation

*NOTE: To install and configure Java-based GUI RAID Manager successfully,
       We highly recommend you refer to INSTALLATION GUIDE in advance.

EOF
 
echo "Would you like to install Java-based GUI RAID Manager now ?"
agreed=
while [ x$agreed = x ]; do
    echo "Please type yes or no."
    read reply 
    case $reply in
       y* | Y*)
          java -Djava.compiler="" -jar installshield.jar > /dev/null 2>&1;
          agreed=1;;
       n* | N*)
          echo "Install Java-based GUI RAID Manager Canceled !";
          agreed=1;;
    esac
done
